/**
 *   Script Tag Library
 *   Copyright 2010 Stani Ryabenkiy
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *   
 */
package org.apache.taglibs.extended.script;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

/**
 * Scriptlet tag for processing JSP scriptlets in languages other than Java.
 * 
 * Partially based on BSF Tag Library, Copyright 1999,2004 The Apache Software Foundation.
 * 
 * @author Stani Ryabenkiy <stani@ryabenkiy.com>
 * 
 */
public class ScriptletTag implements BodyTag {
	protected Tag parent;
	protected BodyContent bodyOut;
	protected PageContext pageContext;
	protected String language;

	public void setLanguage(String value) {
		language = value;
	};

	public void setParent(Tag parent) {
		this.parent = parent;
	};

	public Tag getParent() {
		return (this.parent);
	};

	public void doInitBody() throws JspException {
	};

	public int doAfterBody() throws JspException {
		return 0;
	};

	public void setBodyContent(BodyContent bodyOut) {
		this.bodyOut = bodyOut;
	};

	public int doStartTag() throws JspException {
		return (EVAL_BODY_BUFFERED);
	};

	public void release() {
	};

	public void setPageContext(PageContext pageContext) {
		this.pageContext = pageContext;
	};



	public int doEndTag() throws JspException {
		try {
			JspWriter out = pageContext.getOut();
			if (bodyOut == null)
				return (EVAL_PAGE);
			
			// get a script engine for the language defined in language attribute
			ScriptEngine engine = new ScriptEngineManager().getEngineByName(language);
				
			if (engine == null)
				throw new Exception("Could not locate ScriptEngine for " + language);
			
			try {	
				// populate engine with implicit objects normally available in a JSP
				engine.put("request", pageContext.getRequest());
				engine.put("response", pageContext.getResponse());
				engine.put("pageContext", pageContext);
				engine.put("application", pageContext.getServletContext());
				engine.put("out", out);
				engine.put("config", pageContext.getServletConfig());
				engine.put("page", pageContext.getPage());
				engine.put("exception", pageContext.getException());
				engine.put("session", pageContext.getSession());
			} catch (Exception e) {
				out.println(e.toString());
				e.printStackTrace();
			}
			
			// evaluate script
			engine.eval(bodyOut.getString());

		} catch (Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
		return (EVAL_PAGE);
	};
}
